/* $XFree86: xc/programs/Xserver/hw/xfree86/vga256/drivers/mxic/mxic_rop.h,v 1.1.2.2 1997/06/29 08:43:38 dawes Exp $ */
/*
 *
 * Copyright 1995-1997 The XFree86 Project, Inc.
 *
 */
/* This file contains the data structures which map the X ROPs to the
 * ViRGE ROPs. It also contains other mappings which are used when supporting
 * planemasks and transparency.
 *
 * Created by Sebastien Marineau, 29/03/97.
 * This file should be included only from mxic_accel.c to avoid 
 * duplicate symbols. 
 * 
 */
/*
 * Modified by Stephen H.L.Wang
 *
 * version 0.2alpha - 12/29/1997
 */

 /* The Mix ROPs (selected ones, not all 256)  */

#define	ROP_0				(0x00<<8)
#define	ROP_DSon			(0x11<<8)
#define	ROP_DSna			(0x22<<8)
#define	ROP_Sn				(0x33<<8)
#define	ROP_SDna			(0x44<<8)
#define	ROP_Dn				(0x55<<8)
#define	ROP_DSx				(0x66<<8)
#define	ROP_DSan			(0x77<<8)
#define	ROP_DSa				(0x88<<8)
#define	ROP_DSxn			(0x99<<8)
#define	ROP_D				(0xaa<<8)
#define	ROP_DSno			(0xbb<<8)
#define	ROP_S				(0xcc<<8)
#define	ROP_SDno			(0xdd<<8)
#define	ROP_DSo				(0xee<<8)
#define	ROP_1				(0xff<<8)

/* ROP  ->  (ROP & P) | (D & ~P) */
#define	ROP_0_PaDPnao    /* DPna     */	(0x0a<<8)
#define	ROP_DSon_PaDPnao /* PDSPaox  */	(0x1a<<8)
#define	ROP_DSna_PaDPnao /* DPSana   */	(0x2a<<8)
#define	ROP_Sn_PaDPnao   /* SPDSxox  */	(0x3a<<8)
#define	ROP_SDna_PaDPnao /* DPSDoax  */	(0x4a<<8)
#define	ROP_Dn_PaDPnao   /* DPx      */	(0x5a<<8)
#define	ROP_DSx_PaDPnao  /* DPSax    */	(0x6a<<8)
#define	ROP_DSan_PaDPnao /* DPSDnoax */	(0x7a<<8)
#define	ROP_DSa_PaDPnao  /* DSPnoa   */	(0x8a<<8)
#define	ROP_DSxn_PaDPnao /* DPSnax   */	(0x9a<<8)
#define	ROP_D_PaDPnao    /* D        */	(0xaa<<8)
#define	ROP_DSno_PaDPnao /* DPSnao   */	(0xba<<8)
#define	ROP_S_PaDPnao    /* DPSDxax  */	(0xca<<8)
#define	ROP_SDno_PaDPnao /* DPSDanax */	(0xda<<8)
#define	ROP_DSo_PaDPnao  /* DPSao    */ (0xea<<8)
#define	ROP_1_PaDPnao    /* DPo      */	(0xfa<<8)


/* S -> P */
#define	ROP_DPon			(0x05<<8)
#define	ROP_DPna			(0x0a<<8)
#define	ROP_Pn				(0x0f<<8)
#define	ROP_PDna			(0x50<<8)
#define	ROP_DPx				(0x5a<<8)
#define	ROP_DPan			(0x5f<<8)
#define	ROP_DPa				(0xa0<<8)
#define	ROP_DPxn			(0xa5<<8)
#define	ROP_DPno			(0xaf<<8)
#define	ROP_P				(0xf0<<8)
#define	ROP_PDno			(0xf5<<8)
#define	ROP_DPo				(0xfa<<8)

/* ROP -> (ROP & S) | (~ROP & D) */
#define ROP_DPSDxax			(0xca<<8)
#define ROP_DSPnoa			(0x8a<<8)
#define ROP_DPSao			(0xea<<8)
#define ROP_DPSoa			(0xa8<<8)
#define ROP_DSa				(0x88<<8)
#define ROP_SSPxDSxax			(0xe8<<8)
#define ROP_SDPoa			(0xc8<<8)
#define ROP_DSPnao			(0xae<<8)
#define ROP_SSDxPDxax			(0x8e<<8)
#define ROP_DSo				(0xee<<8)
#define ROP_SDPnao			(0xce<<8)
#define ROP_SPDSxax			(0xac<<8)
#define ROP_SDPnoa			(0x8c<<8)
#define ROP_SDPao			(0xec<<8)

/* ROP_sp -> (ROP_sp & S) | (D & ~S) */
#define	ROP_0_SaDSnao    /* DSna     */	(0x22<<8)
#define	ROP_DPa_SaDSnao  /* DPSnoa   */	(0xa2<<8)
#define	ROP_PDna_SaDSnao /* DSPDoax  */	(0x62<<8)
#define	ROP_P_SaDSnao    /* DSPDxax  */	(0xe2<<8)
#define	ROP_DPna_SaDSnao /* DPSana   */	(0x2a<<8)
#define	ROP_D_SaDSnao    /* D        */	(0xaa<<8)
#define	ROP_DPx_SaDSnao  /* DPSax    */	(0x6a<<8)
#define	ROP_DPo_SaDSnao  /* DPSao    */	(0xea<<8)
#define	ROP_DPon_SaDSnao /* SDPSaox  */	(0x26<<8)
#define	ROP_DPxn_SaDSnao /* DSPnax   */	(0xa6<<8)
#define	ROP_Dn_SaDSnao   /* DSx      */	(0x66<<8)
#define	ROP_PDno_SaDSnao /* SDPSanax */	(0xe6<<8)
#define	ROP_Pn_SaDSnao   /* PSDPxox  */	(0x2e<<8)
#define	ROP_DPno_SaDSnao /* DSPnao   */	(0xae<<8)
#define	ROP_DPan_SaDSnao /* SDPSnoax */	(0x6e<<8)
#define	ROP_1_SaDSnao    /* DSo      */	(0xee<<8)


static int mxicAlu[16] =
{
   ROP_0,               /* GXclear */
   ROP_DSa,             /* GXand */
   ROP_SDna,            /* GXandReverse */
   ROP_S,               /* GXcopy */
   ROP_DSna,            /* GXandInverted */
   ROP_D,               /* GXnoop */
   ROP_DSx,             /* GXxor */
   ROP_DSo,             /* GXor */
   ROP_DSon,            /* GXnor */
   ROP_DSxn,            /* GXequiv */
   ROP_Dn,              /* GXinvert*/
   ROP_SDno,            /* GXorReverse */
   ROP_Sn,              /* GXcopyInverted */
   ROP_DSno,            /* GXorInverted */
   ROP_DSan,            /* GXnand */
   ROP_1                /* GXset */
};

/* S -> P, for solid and pattern fills. */
static int mxicAlu_sp[16]=
{
   ROP_0,
   ROP_DPa,
   ROP_PDna,
   ROP_P,
   ROP_DPna,
   ROP_D,
   ROP_DPx,
   ROP_DPo,
   ROP_DPon,
   ROP_DPxn,
   ROP_Dn,
   ROP_PDno,
   ROP_Pn,
   ROP_DPno,
   ROP_DPan,
   ROP_1
};

/* ROP  ->  (ROP & P) | (D & ~P) */
/* These are used to support a planemask for S->D ops */
static int mxicAlu_pat[16] =
{
   ROP_0_PaDPnao,
   ROP_DSa_PaDPnao,
   ROP_SDna_PaDPnao,
   ROP_S_PaDPnao,
   ROP_DSna_PaDPnao,
   ROP_D_PaDPnao,
   ROP_DSx_PaDPnao,
   ROP_DSo_PaDPnao,
   ROP_DSon_PaDPnao,
   ROP_DSxn_PaDPnao,
   ROP_Dn_PaDPnao,
   ROP_SDno_PaDPnao,
   ROP_Sn_PaDPnao,
   ROP_DSno_PaDPnao,
   ROP_DSan_PaDPnao,
   ROP_1_PaDPnao
};

/* ROP_sp -> (ROP_sp & S) | (D & ~S) */
/* This is used for our transparent mono pattern fills to support trans/plane*/
static int mxicAlu_MonoTrans[16] =
{
   ROP_0_SaDSnao,
   ROP_DPa_SaDSnao,
   ROP_PDna_SaDSnao,
   ROP_P_SaDSnao,
   ROP_DPna_SaDSnao,
   ROP_D_SaDSnao,
   ROP_DPx_SaDSnao,
   ROP_DPo_SaDSnao,
   ROP_DPon_SaDSnao,
   ROP_DPxn_SaDSnao,
   ROP_Dn_SaDSnao,
   ROP_PDno_SaDSnao,
   ROP_Pn_SaDSnao,
   ROP_DPno_SaDSnao,
   ROP_DPan_SaDSnao,
   ROP_1_SaDSnao
};
